//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Enums
//:
//: An optional is an enum.
//:
//: This means we can use a switch statement and access any associated values stored.
//:
//: -------------------
//:
//: [Next Page  ▶](@next)
//:
//: -------------------
//:


// optional binding
let someValueToUnwrap: Int? = 56
if let unwrappedValue = someValueToUnwrap {
    print(unwrappedValue)
}

// perform a switch on the enum
switch someValueToUnwrap {
case .some(let unwrappedValue):
    // TODO: print the unwrapped value
case .none:
    print("Switch statement found nil")
}


//:
//: -------------------
//:
//: ## Task:
//:
//: Finish the code above and print the unwrapped value to the console
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:
